(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     18685,        534]
NotebookOptionsPosition[     13704,        433]
NotebookOutlinePosition[     14306,        453]
CellTagsIndexPosition[     14263,        450]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["D| References and further reading", "Section",
 CellFrame->{{0.5, 3}, {3, 0.5}},
 CellChangeTimes->{{3.9643174291306467`*^9, 3.964317437438129*^9}, {
   3.9648868284499207`*^9, 3.964886833698546*^9}, 3.9687226853821173`*^9, 
   3.9728201768136997`*^9, {3.972835047554768*^9, 3.972835057361251*^9}, 
   3.9729024506576557`*^9},
 FontColor->GrayLevel[0],
 CellID->1491668001,ExpressionUUID->"18262490-0e29-461b-a307-a56a2a3c86e5"],

Cell["\<\
Mathematica' s documentation covers the use of finite elements very well, so \
many of the references here are to that documentation. Copy the reference and \
paste it into the browser. It will either go directly to the page or to a \
list of pages with the required page at, or near, the top.\
\>", "Text",
 CellChangeTimes->{{3.972870205554159*^9, 3.972870264907219*^9}, {
  3.9728718739183893`*^9, 3.9728719447714148`*^9}},
 CellID->188099984,ExpressionUUID->"4157b534-a645-4897-aaeb-c886ab8cae06"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Geometry", "Section",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.971056711494503*^9, 
  3.971056713652994*^9}},ExpressionUUID->"90342adf-006e-4f79-ac66-\
2afed1c115b6"],

Cell[CellGroupData[{

Cell["Using OpenCascadeLink", "Subsubsection",
 CellChangeTimes->{{3.971056552693357*^9, 
  3.971056555169382*^9}},ExpressionUUID->"17639dc9-c431-415e-8b4e-\
c7d6e3a1e91c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"https", ":"}], "//", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"reference", ".", "wolfram", ".", "com"}], "/", "language"}], "/",
      "OpenCascadeLink"}], "/", "tutorial"}], "/", 
   RowBox[{"UsingOpenCascadeLink", ".", "html"}]}]}]], "Input",
 CellChangeTimes->{{3.971056541804699*^9, 
  3.971056541806959*^9}},ExpressionUUID->"41c5951f-5a00-441b-b6fe-\
a919bb8c51eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derived Geometric Regions", "Subsubsection",
 CellChangeTimes->{
  3.971056610489471*^9},ExpressionUUID->"1aa4ee84-1126-4726-87e9-\
412e0977d0cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"https", ":"}], "//", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"reference", ".", "wolfram", ".", "com"}], "/", "language"}], "/",
     "guide"}], "/", 
   RowBox[{"DerivedRegions", ".", "html"}]}]}]], "Input",
 CellChangeTimes->{{3.9710566243063498`*^9, 
  3.971056624308661*^9}},ExpressionUUID->"8a3454ea-92aa-4af4-ae96-\
71152ccb4edc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ShapeSurfaceOptions -", "Subsubsection",
 CellChangeTimes->{
  3.972620989673073*^9},ExpressionUUID->"e3367ed7-e2e9-48e9-ab19-\
778ffce94503"],

Cell[BoxData[
 RowBox[{
  RowBox[{"OpenCascadeLink", "/", "ref"}], "/", 
  "OpenCascadeShapeSurfaceMeshToBoundaryMesh"}]], "Input",
 CellChangeTimes->{{3.96607171853074*^9, 3.966071720951132*^9}, 
   3.9726209823531237`*^9},
 CellID->260363632,ExpressionUUID->"ff090448-f18a-4046-8ab2-a304b19c8e09"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mesh Generation", "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{
  3.971056752744914*^9},ExpressionUUID->"21b48606-a6ce-4282-8cb5-\
fc545d6c4688"],

Cell[CellGroupData[{

Cell["Element Mesh Generation", "Subsubsection",
 CellChangeTimes->{
  3.9710567907817707`*^9},ExpressionUUID->"ac52242d-665f-4bdd-9eef-\
07c3ef34fc48"],

Cell[BoxData[
 RowBox[{
  RowBox[{"https", ":"}], "//", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"reference", ".", "wolfram", ".", "com"}], "/", "language"}], "/",
      "FEMDocumentation"}], "/", "tutorial"}], "/", 
   RowBox[{"ElementMeshCreation", ".", "html"}]}]}]], "Input",
 CellChangeTimes->{{3.971056800729019*^9, 
  3.971056800732388*^9}},ExpressionUUID->"c260d3e8-cab9-41c1-bb4d-\
eec7e8786bcb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Element Mesh Visualization", "Subsubsection",
 CellChangeTimes->{
  3.9710568935391273`*^9},ExpressionUUID->"37b7505c-7727-41d8-b363-\
463452ae52f6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"https", ":"}], "//", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"reference", ".", "wolfram", ".", "com"}], "/", "language"}], "/",
      "FEMDocumentation"}], "/", "tutorial"}], "/", 
   RowBox[{"ElementMeshVisualization", ".", "html"}]}]}]], "Input",
 CellChangeTimes->{{3.971056903758946*^9, 
  3.9710569037621603`*^9}},ExpressionUUID->"414dfa49-57a4-4ca0-9c34-\
f3b65ad0888b"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solid Mechanics", "Section",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{
  3.97105742731091*^9},ExpressionUUID->"ccba4d35-68a1-4cd0-87d8-ffd1b32a5332"],

Cell["\<\
Introduction - An excellent introduction to the FEM for solid mechanics by \
the author of Mathematica\[CloseCurlyQuote]s package.\
\>", "Text",
 CellChangeTimes->{{3.9725592293823137`*^9, 3.972559235096189*^9}, {
  3.9728720775392923`*^9, 
  3.972872155299205*^9}},ExpressionUUID->"d1f2b51e-d4df-4f7a-b9de-\
b5e795ded391"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"https", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{"www", ".", "wolfram", ".", "com"}], "/", "broadcast"}], "/", 
     RowBox[{"video", ".", 
      RowBox[{"php", "?", "v"}]}]}]}], "=", "3529"}], "inTextCode"]], "Input",\

 CellChangeTimes->{{3.972559216543836*^9, 
  3.972559216545238*^9}},ExpressionUUID->"de853641-db16-4928-89ca-\
f5fd7c5af4f1"],

Cell[CellGroupData[{

Cell["PDE Monograph", "Subsubsection",
 CellChangeTimes->{{3.971057476118495*^9, 
  3.971057486178232*^9}},ExpressionUUID->"caf2529b-51c8-4b4f-bb9b-\
cac3fd439129"],

Cell["\<\
Links to an Overview, types of analysis, boundary conditions etc.\
\>", "Text",
 CellChangeTimes->{{3.971057507305085*^9, 3.971057509438731*^9}, {
  3.971057545012356*^9, 
  3.9710575725098543`*^9}},ExpressionUUID->"8740f5df-278d-4740-9128-\
bf2026baa65e"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"reference", ".", "wolfram", ".", "com"}], "/", "language"}], 
       "/", "PDEModels"}], "/", "tutorial"}], "/", "StructuralMechanics"}], "/", 
    RowBox[{"SolidMechanics", ".", "html", ".", "ja"}]}]}], 
  "inTextCode"]], "Input",
 CellChangeTimes->{{3.972565061391391*^9, 
  3.972565061394158*^9}},ExpressionUUID->"1db786bc-dd85-4069-9174-\
51c353016858"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Natural frequencies ",
 StyleBox["(Paste into the search engine on Wolfram Documentation viewer)",
  FontColor->GrayLevel[0]]
}], "Subsubsection",
 CellChangeTimes->{{3.972617102633367*^9, 3.972617108915413*^9}, {
  3.972902217568707*^9, 
  3.972902258249956*^9}},ExpressionUUID->"db92be96-be45-4092-af2f-\
919ad91d9609"],

Cell[TextData[{
 StyleBox[" \t", "Text"],
 StyleBox["PDEModels/tutorial/StructuralMechanics/SolidMechanics#1381102279", 
  "inTextCode",
  FontColor->GrayLevel[0]]
}], "inTextCode",
 CellChangeTimes->{{3.96536591661972*^9, 3.965365935048648*^9}, 
   3.972617119274632*^9, 
   3.9728352205776377`*^9},ExpressionUUID->"238b3e3e-f013-4131-97d2-\
8409e29ae94d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finite Element Method Usage Tips", "Subsection",
 CellChangeTimes->{
  3.971057350063672*^9},ExpressionUUID->"02ba5b4f-0c90-41b7-99b4-\
e0968a951775"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"reference", ".", "wolfram", ".", "com"}], "/", "language"}], "/",
       "FEMDocumentation"}], "/", "tutorial"}], "/", 
    RowBox[{"FiniteElementBestPractice", ".", "html"}]}]}], 
  "inTextCode"]], "Input",
 CellChangeTimes->{{3.972901717770432*^9, 3.97290171777324*^9}},
 CellID->53716374,ExpressionUUID->"e235b32c-0e21-4931-abf2-16833b93b80b"],

Cell[CellGroupData[{

Cell["Reaction forces", "Subsubsection",
 CellChangeTimes->{{3.972559696820633*^9, 
  3.972559700555578*^9}},ExpressionUUID->"b2caa57d-32ae-4221-b3b3-\
dbb3973f78c3"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"reference", ".", "wolfram", ".", "com"}], "/", "language"}],
         "/", "PDEModels"}], "/", "tutorial"}], "/", "StructuralMechanics"}], 
     "/", 
     RowBox[{"SolidMechanics", ".", "html"}]}], "#1411796410"}]}], 
  "inTextCode"]], "Input",
 CellChangeTimes->{{3.972559704193996*^9, 
  3.972559704195636*^9}},ExpressionUUID->"61e0fbb1-38fd-4ff9-8ef2-\
a5e3808f9180"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Verification", "Subsubsection",
 CellChangeTimes->{{3.971085441029703*^9, 
  3.971085444093685*^9}},ExpressionUUID->"cfb52943-7656-4ce7-985a-\
4188e44438b7"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"reference", ".", "wolfram", ".", "com"}], "/", "language"}], 
       "/", "PDEModels"}], "/", "tutorial"}], "/", "StructuralMechanics"}], "/", 
    RowBox[{"SolidMechanicsVerificationTests", ".", "html"}]}]}], 
  "inTextCode"]], "Input",
 CellChangeTimes->{{3.9710854504214973`*^9, 
  3.971085470293638*^9}},ExpressionUUID->"6d4b66af-dbf2-4097-95e3-\
4737d9b3eb0f"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other references", "Section",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{
  3.652728456208679*^9, 3.652728527108994*^9, {3.972870294835545*^9, 
   3.9728702981906157`*^9}},
 CellID->1010306106,ExpressionUUID->"a888d5fe-3c3b-4ce7-abe6-871a109ed802"],

Cell[TextData[StyleBox["Theory of plates and shells\nS. Timoshenko and S. \
Woinowsky-Krieger\n. Engineering societies monographs. McGraw-Hill, New York, \
2D ed edition, 1959", "inTextCode"]], "Text",
 CellChangeTimes->{3.972870810210936*^9},
 CellID->1438782064,ExpressionUUID->"bf800e2a-671e-4517-b1c9-12041c52cd26"],

Cell[TextData[StyleBox["Roark' s formulas for stress and strain\nR . J . \
Roark, W . C . Young, and R . G . Budynas\n. McGraw - Hill, New York, 7 Th ed \
edition, 2002\nISBN : 007072542 X", "inTextCode"]], "Text",
 CellChangeTimes->{{3.972870902928936*^9, 3.9728709067195673`*^9}},
 CellID->944284428,ExpressionUUID->"f059bc59-cddd-4ecc-a891-e8f256f9da51"],

Cell[TextData[StyleBox["Wood, R.H., \[OpenCurlyDoubleQuote]The Reinforcement \
of Slabs in Accordance with a Pre-Determined Field of Moments,\
\[CloseCurlyDoubleQuote] Concrete, Vol. 2, No. 2, February 1968, pp. 69-76.", \
"inTextCode"]], "Text",
 CellChangeTimes->{3.97287121500321*^9},
 CellID->684230066,ExpressionUUID->"8b491fff-ab7f-4d56-a59b-67decc94cd66"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 3", "Section",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.972726569027302*^9, 
  3.972726573693224*^9}},ExpressionUUID->"b5a4666c-fb5a-4395-8333-\
0db41a7e0d6a"],

Cell["Discussion on accuracy of tables and plate design", "Text",
 CellChangeTimes->{{3.972726631582631*^9, 
  3.972726651300695*^9}},ExpressionUUID->"c1466b9a-b588-46c7-9c24-\
6365da42f98b"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"onlinelibrary", ".", "wiley", ".", "com"}], "/", "doi"}], "/",
       "10.1155"}], "/", "2019"}], "/", "1560171"}]}], "inTextCode"]], "Input",\

 CellChangeTimes->{{3.972726577607912*^9, 
  3.972726577609737*^9}},ExpressionUUID->"8a7a75b4-2527-4002-8483-\
0a290b19ee26"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"engineering", ".", "stackexchange", ".", "com"}], "/", 
       "questions"}], "/", "50164"}], "/", "maximum"}], "-", "stress", "-", 
    "and", "-", "deflection", "-", "of", "-", "rectangular", "-", "plates", "-",
     "under", "-", "hydrostatic", "-", "load", "-", "tal"}]}], 
  "inTextCode"]], "Input",
 CellChangeTimes->{{3.972726597376005*^9, 
  3.9727265973771753`*^9}},ExpressionUUID->"2053ad0f-16e1-4c9e-b1ba-\
d581666e9dce"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General Reading", "Section",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{
  3.652728456208679*^9, 3.652728527108994*^9, {3.972835364007607*^9, 
   3.972835368891959*^9}},
 CellID->1862064811,ExpressionUUID->"4e5249b6-6f97-44b1-aa81-1724f0e37d5e"],

Cell[TextData[StyleBox["Computational Engineering, Peter Debney, The \
Institution of Structural Engineers, 2020", "inTextCode"]], "Text",
 CellChangeTimes->{{3.972835508581493*^9, 3.972835571376783*^9}},
 CellID->836021703,ExpressionUUID->"d0b82322-8079-4667-bb93-ef61fd747b74"],

Cell["\<\
An excellent and very readable text that deals with parametric design and \
finite element and other methods of analysis, describing the advantages and \
pitfalls. Highly recommended.\
\>", "Text",
 CellFrame->{{0, 0}, {3, 0}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.972835801932393*^9, 3.9728358962799664`*^9}},
 CellID->638405709,ExpressionUUID->"9ad450d1-5a6a-4dad-a7e9-e3b6b709a5c4"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{116, Automatic}, {Automatic, 82}},
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "MyBookStyles.nb"]]}, Visible -> False, 
  FrontEndVersion -> "14.3 for Mac OS X ARM (64-bit) (July 8, 2025)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"4734a96b-d155-41a1-a46f-5d8911acfc88"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 434, 7, 49, "Section",ExpressionUUID->"18262490-0e29-461b-a307-a56a2a3c86e5",
 CellID->1491668001],
Cell[1013, 31, 511, 8, 57, "Text",ExpressionUUID->"4157b534-a645-4897-aaeb-c886ab8cae06",
 CellID->188099984]
}, Open  ]],
Cell[CellGroupData[{
Cell[1561, 44, 217, 5, 37, "Section",ExpressionUUID->"90342adf-006e-4f79-ac66-2afed1c115b6"],
Cell[CellGroupData[{
Cell[1803, 53, 172, 3, 25, "Subsubsection",ExpressionUUID->"17639dc9-c431-415e-8b4e-c7d6e3a1e91c"],
Cell[1978, 58, 429, 12, 25, "Input",ExpressionUUID->"41c5951f-5a00-441b-b6fe-a919bb8c51eb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2444, 75, 152, 3, 25, "Subsubsection",ExpressionUUID->"1aa4ee84-1126-4726-87e9-412e0977d0cc"],
Cell[2599, 80, 380, 11, 25, "Input",ExpressionUUID->"8a3454ea-92aa-4af4-ae96-71152ccb4edc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3016, 96, 148, 3, 25, "Subsubsection",ExpressionUUID->"e3367ed7-e2e9-48e9-ab19-778ffce94503"],
Cell[3167, 101, 299, 6, 25, "Input",ExpressionUUID->"ff090448-f18a-4046-8ab2-a304b19c8e09",
 CellID->260363632]
}, Open  ]],
Cell[CellGroupData[{
Cell[3503, 112, 203, 5, 37, "Subsection",ExpressionUUID->"21b48606-a6ce-4282-8cb5-fc545d6c4688"],
Cell[CellGroupData[{
Cell[3731, 121, 152, 3, 25, "Subsubsection",ExpressionUUID->"ac52242d-665f-4bdd-9eef-07c3ef34fc48"],
Cell[3886, 126, 429, 12, 25, "Input",ExpressionUUID->"c260d3e8-cab9-41c1-bb4d-eec7e8786bcb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4352, 143, 155, 3, 25, "Subsubsection",ExpressionUUID->"37b7505c-7727-41d8-b363-463452ae52f6"],
Cell[4510, 148, 436, 12, 25, "Input",ExpressionUUID->"414dfa49-57a4-4ca0-9c34-f3b65ad0888b"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5007, 167, 197, 4, 37, "Section",ExpressionUUID->"ccba4d35-68a1-4cd0-87d8-ffd1b32a5332"],
Cell[5207, 173, 333, 7, 25, "Text",ExpressionUUID->"d1f2b51e-d4df-4f7a-b9de-b5e795ded391"],
Cell[5543, 182, 421, 13, 25, "Input",ExpressionUUID->"de853641-db16-4928-89ca-f5fd7c5af4f1"],
Cell[CellGroupData[{
Cell[5989, 199, 164, 3, 25, "Subsubsection",ExpressionUUID->"caf2529b-51c8-4b4f-bb9b-cac3fd439129"],
Cell[6156, 204, 266, 6, 25, "Text",ExpressionUUID->"8740f5df-278d-4740-9128-bf2026baa65e"],
Cell[6425, 212, 514, 15, 25, "Input",ExpressionUUID->"1db786bc-dd85-4069-9174-51c353016858"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6976, 232, 339, 8, 25, "Subsubsection",ExpressionUUID->"db92be96-be45-4092-af2f-919ad91d9609"],
Cell[7318, 242, 357, 9, 25, "inTextCode",ExpressionUUID->"238b3e3e-f013-4131-97d2-8409e29ae94d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7712, 256, 156, 3, 25, "Subsection",ExpressionUUID->"02ba5b4f-0c90-41b7-99b4-e0968a951775"],
Cell[7871, 261, 486, 13, 25, "Input",ExpressionUUID->"e235b32c-0e21-4931-abf2-16833b93b80b",
 CellID->53716374],
Cell[CellGroupData[{
Cell[8382, 278, 166, 3, 25, "Subsubsection",ExpressionUUID->"b2caa57d-32ae-4221-b3b3-dbb3973f78c3"],
Cell[8551, 283, 546, 17, 25, "Input",ExpressionUUID->"61e0fbb1-38fd-4ff9-8ef2-a5e3808f9180"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9134, 305, 163, 3, 25, "Subsubsection",ExpressionUUID->"cfb52943-7656-4ce7-985a-4188e44438b7"],
Cell[9300, 310, 522, 15, 41, "Input",ExpressionUUID->"6d4b66af-dbf2-4097-95e3-4737d9b3eb0f"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9883, 332, 294, 6, 37, "Section",ExpressionUUID->"a888d5fe-3c3b-4ce7-abe6-871a109ed802",
 CellID->1010306106],
Cell[10180, 340, 319, 4, 57, "Text",ExpressionUUID->"bf800e2a-671e-4517-b1c9-12041c52cd26",
 CellID->1438782064],
Cell[10502, 346, 357, 4, 100, "Text",ExpressionUUID->"f059bc59-cddd-4ecc-a891-e8f256f9da51",
 CellID->944284428],
Cell[10862, 352, 362, 5, 56, "Text",ExpressionUUID->"8b491fff-ab7f-4d56-a59b-67decc94cd66",
 CellID->684230066]
}, Open  ]],
Cell[CellGroupData[{
Cell[11261, 362, 218, 5, 112, "Section",ExpressionUUID->"b5a4666c-fb5a-4395-8333-0db41a7e0d6a"],
Cell[11482, 369, 191, 3, 36, "Text",ExpressionUUID->"c1466b9a-b588-46c7-9c24-6365da42f98b"],
Cell[11676, 374, 410, 13, 28, "Input",ExpressionUUID->"8a7a75b4-2527-4002-8483-0a290b19ee26"],
Cell[12089, 389, 572, 15, 52, "Input",ExpressionUUID->"2053ad0f-16e1-4c9e-b1ba-d581666e9dce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12698, 409, 291, 6, 112, "Section",ExpressionUUID->"4e5249b6-6f97-44b1-aa81-1724f0e37d5e",
 CellID->1862064811],
Cell[12992, 417, 279, 3, 34, "Text",ExpressionUUID->"d0b82322-8079-4667-bb93-ef61fd747b74",
 CellID->836021703],
Cell[13274, 422, 414, 8, 94, "Text",ExpressionUUID->"9ad450d1-5a6a-4dad-a7e9-e3b6b709a5c4",
 CellID->638405709]
}, Open  ]]
}
]
*)

